$title: (2) Split GTAP Land Use to Irrigated-Rinfed

*--------------------------------------------------*
*                                                         *
*            Global Trade Analysis Project                *
*                GTAP Water Database                      *
*                     SplitLand                           *
*  ch 2: Splitting GTAP Land Use to Irrigated Rain Fed    *
*                                                         *
*--------------------------------------------------*


Parameters
  HI       Irrigated Harvested Area in 2011 in hectares,
  HR       Rain fed Harvested Area in 2011 in hectares,
  QI       Irrigated Production in 2011 in metric tons,
  QR       Rain fed Production in 2011 in metric tons,
  h_miss   check harvested area,
  q_miss   check production,
  xhvst    Area share of irr in each RBAEZ,
  xprdn    Prod share of irr in each RBAEZ;


*    share based on 2000 Siebert data
xhvst(a,b,c,reg)$hvst0(reg,b,a,c) = (area00("rfd",reg,b,a,c)/hvst0(reg,b,a,c));
xprdn(a,b,c,reg)$prod0(reg,b,a,c) = (prod00("rfd",reg,b,a,c)/prod0(reg,b,a,c));

*    General share if no 2000 production
*xhvst(a,b,c,reg)$(not hvst0(reg,b,a,c) and sum((r,rb),hvst0(r,rb,a,c))) =
*     sum((r,rb),area00("irr",r,rb,a,c))/sum((r,rb),hvst0(r,rb,a,c));
*xprdn(a,b,c,reg)$(not prod0(reg,b,a,c) and sum((r,rb),prod0(r,rb,a,c))) =
*     sum((r,rb),prod00("irr",r,rb,a,c))/sum((r,rb),prod0(r,rb,a,c));

hi(a,b,c,reg) = hvst(a,b,c,reg) * (1-xhvst(a,b,c,reg));
hr(a,b,c,reg) = hvst(a,b,c,reg) * (0+xhvst(a,b,c,reg));
qi(a,b,c,reg) = prdn(a,b,c,reg) * (1-xprdn(a,b,c,reg));
qr(a,b,c,reg) = prdn(a,b,c,reg) * (0+xprdn(a,b,c,reg));

hi(a,b,c,reg)$(not hi(a,b,c,reg)) =  eps;
hr(a,b,c,reg)$(not hr(a,b,c,reg)) =  eps;
qi(a,b,c,reg)$(not qi(a,b,c,reg)) =  eps;
qr(a,b,c,reg)$(not qr(a,b,c,reg)) =  eps;

h_miss(a,b,c,r)$(hvst(a,b,c,r)>eps and not hvst0(r,b,a,c)) = -1;
q_miss(a,b,c,r)$(prdn(a,b,c,r)>eps and not prod0(r,b,a,c)) = -1;

parameter error;
error("hvst",a,b,c,reg) = hvst(a,b,c,reg) -hi(a,b,c,reg)-hr(a,b,c,reg) +eps;
error("prdn",a,b,c,reg) = prdn(a,b,c,reg) -qi(a,b,c,reg)-qr(a,b,c,reg) +eps;
